<!DOCTYPE html>
<html>
<head>
    <title> Ticket Progress</title>
</head>
<body>
    <h2> Log Progress for a Ticket</h2>
    
    <p>
        <a href="support_form.php" target="blank" style="text-decoration: none; color; blue;">
            Support Form
        </a><br>
        
        <a href="existing_solutions.php" target="blank" style="text-decoration: none; color: blue;">
             Search for Exisitng Solutions
        </a><br>
        
        <a href="followupqueries.php" target="blank" style="text-decoration: none; color; blue">
             Follow Up Queries
             
        </a><br>
        <a href="dashboard.php" target="blank" style="text-decoration: none; color; blue;">
             Dashboard Reporting
         </a>
        
    </p>
    <form method="GET" action="">
        <label for="ticket_id">Enter Ticket ID:</label>
        <input type="number" name="ticket_id" required>
        <input type="submit" value="Search">
    </form>
    
    <?php
    // Checks if the ticket ID has been submitted
    if(isset($_GET['ticket_id'])) {
    $conn = new mysqli("localhost", "calank_Guest", "WTBH83LmnNFg","calank_Client_Support_System");
    
    if ($conn->connect_error){
        die("Connection failed: ". $conn->connect_error);
    }
    
    $ticket_id = (int) $_GET['ticket_id'];
    
    $sql = "SELECT * FROM tickets WHERE ticket_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $ticket_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    // If the ticket is found display the details and the progress form
    if ($result->num_rows > 0) {
        $ticket = $result->fetch_assoc();
        echo "<h3>Ticket Details:</h3>";
        echo "<p><strong>Ticket #{$ticket['ticket_id']}</strong><br>";
        echo "<strong>Issue Description:</strong> {$ticket['issue_description']}<br>";
        echo "<strong>Status:</strong>{$ticket['status_type']}<br>";
        echo "<strong>Category:</strong>{$ticket['category']}<br>";

        
        echo '<form method="POST" action="">';
        echo '<label for="note">Progress Note:</label><br>';
        echo '<textarea name= "note" required rows="5" cols="50"></textarea><br><br>';
        echo '<label for="steps_taken">Steps Taken:</label><br>';
        echo '<textarea name="steps_taken" required rows="8" cols="80"></textarea><br><br>';
        echo '<label for="tests_conducted">Tests Conducted:</label><br>';
        echo '<textarea name="tests_conducted" required rows="8" cols="80"></textarea><br><br>';
        echo '<label for="interim_solution">Interim Solution / Final Solution:</label><br>';
        echo '<textarea name="interim_solution" required rows="8" cols="80"></textarea><br><br>';
        echo '<label for="status_type">Ticket Status:</label><br>';
        echo '<select name="status_type" required>';
        echo '<option value="Open">Open</option>';
        echo '<option value="Closed">Closed</option>';;
        echo '</select><br><br>';
        echo '<input type= "submit" value="Save Progress NOTE">';
        echo '<input type="hidden" name="ticket_id" value="' .$ticket_id . '">';
        echo '</form>';
        
    }else{
        // Displayed if no ticket is found
        echo "<p style='color: red;'>Ticket ID not found. Please try again.</p>";
        
    }
    
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        if (isset($_POST['note']) && !empty($_POST['note'])) {
            $note = $_POST['note'];
            $steps_taken = $_POST['steps_taken'];
            $tests_conducted = $_POST['tests_conducted'];
            $interim_solution = $_POST['interim_solution'];
            $ticket_id = $_POST['ticket_id'];
            
            $status_type = $_POST['status_type'];
            $closed_at = ($status_type === 'Closed') ? date('Y-m-d H:i:s') : null;
            
            // Insers the progress into the database
            $note_sql = "INSERT INTO progress (ticket_id, note, steps_taken, tests_conducted, interim_solution, status_type, closed_at, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())";
            $stmt = $conn->prepare($note_sql);
            $stmt->bind_param("issssss", $ticket_id, $note, $steps_taken, $tests_conducted, $interim_solution, $status_type, $closed_at);

            
            if($stmt->execute()) {
                echo "<p style='color: green;'>Progress note added succesfully!</p>";
                
                if ($status_type === 'Closed') {
                    $update_ticket_sql = "UPDATE tickets SET status_type = ? WHERE ticket_id = ?";
                    $update_stmt = $conn->prepare($update_ticket_sql);
                    $update_stmt->bind_param("si", $status_type, $ticket_id);
                    $update_stmt->execute();
                }
                
            } else {
                 echo "<p style='color: red;'>Error " .$stmt->error ."</p>";
            }
            
        }
            
        } 
        $conn->close();
    }
    ?>
</body>
</html>
